#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define M_PI 3.14159265358979323846

struct pomeraj {
    long long x, y;
    double ugao;
    int indeks;
};

int uporedi(const void*a, const void*b){

    struct pomeraj*p = (struct pomeraj*)a;
    struct pomeraj*q = (struct pomeraj*)b;

    if (p->ugao < q->ugao) return -1;
    if (p->ugao > q->ugao) return 1;
    return 0;
}

int main(){
    int n;
    scanf("%d", &n);

    struct pomeraj*v = malloc(n * sizeof(struct pomeraj));

    for (int i = 0; i < n; i++){
        scanf("%lld %lld", &v[i].x, &v[i].y);
        v[i].ugao = atan2(v[i].y, v[i].x);
        v[i].indeks = i + 1;
    }
    qsort(v, n, sizeof(struct pomeraj), uporedi);

    struct pomeraj*w = malloc(2*n*sizeof(struct pomeraj));

    for (int i = 0; i < n; i++){
        w[i] = v[i];
        w[i+n] = v[i];
        w[i+n].ugao += 2*M_PI;
    }

    long long sx = 0, sy = 0;
    long long najbolja = 0;
    int najbolji_l = 0, najbolji_r = -1;

    int r = 0;

    for (int l = 0; l < n; l++){
        while (r < l + n && w[r].ugao - w[l].ugao < M_PI) {
            sx += w[r].x;
            sy += w[r].y;
            r++;
        }

        long long distanca = sx*sx + sy*sy;
        if (distanca > najbolja) {
            najbolja = distanca;
            najbolji_l = l;
            najbolji_r = r - 1;
        }
        sx -= w[l].x;
        sy -= w[l].y;
    }
    int k = najbolji_r - najbolji_l + 1;
    printf("%d\n", k);

    for (int i = najbolji_l; i <= najbolji_r; i++) {
        printf("%d ", w[i].indeks);
    }
    printf("\n");
    return 0;
}